/**
* \file: mount.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: automounter
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef AAM_CONTROL_MOUNT_H
#define AAM_CONTROL_MOUNT_H

#include "model/partition.h"
#include "control/watch.h"

typedef struct 
{
	unsigned long mount_flags;
	const char *mount_options;
} mount_options_t;

typedef void (*mount_done_callback_t)(partition_t *partition, error_code_t return_val,
        const mount_options_t *options);

typedef void (*umount_done_callback_t)(partition_t *partition, error_code_t return_val);

error_code_t mount_init(void);

/**
 * Be careful with local variables. The parameters partition and callback_func must
 * be valid at least until the callback_func is executed by the threaded mounter!!!
 * The options data structure is deep copied within this call.
 */
error_code_t mount_start_mount(partition_t *partition, const mount_options_t *options,
        mount_done_callback_t callback_func);

/**
 * Be careful with local variables. The parameters partition and callback_func must
 * be valid at least until the callback_func is executed by the threaded mounter!!!
 */
error_code_t mount_start_unmount(partition_t *partition, umount_done_callback_t callback_func);

error_code_t mount_unmount_sync(const char *mount_point);

void mount_mark_partition_invalid(partition_t *partition);

bool mount_is_someone_working(void);

void mount_deinit(void);


#endif
